// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "gp_internal.h"
#include "gp_dlrec.h"
#include "main.h"
#include "stringCommons.h"

#pragma warning(disable:4127)

DWORD s_xf_data[16];

void __fastcall xf_log_start(DWORD xf_log) {
	XF_LOG x; x.dword = xf_log;
	GPDEGUB("GP XF Load, length=%i, base=0x%04X:", x.length, x.base);
}
void __fastcall xf_log1(DWORD xf_log, DWORD d) {
	XF_LOG x; x.dword = xf_log;
	xf_log_start(xf_log);
	xf_dumpword(x.base, d);
	DEGUB("\n");
}
void __fastcall xf_log_main(DWORD xf_log, DWORD *data) {
	XF_LOG x; x.dword = xf_log;
	int effective_length = MIN(x.length, 16);
	for(int i=0; i<effective_length; i++) {
		xf_dumpword(x.base, data[i]);
	}
	DEGUB("\n");
}
void __fastcall xf_log(DWORD xf_log, DWORD *data) {
	XF_LOG x; x.dword = xf_log;
	xf_log_start(xf_log);
	xf_log_main(xf_log, data);
}
void __fastcall xf_indx_log_start(char name, DWORD xf_indx_log) {
	XF_INDX_LOG x; x.dword = xf_indx_log;
	GPDEGUB("GP Load Index %c, index=%i, length=%i, base=0x%04X:",
		name, x.index, x.length, x.base);
}
void __fastcall xf_indx_log(char name, DWORD xf_indx_log, DWORD *data) {
	XF_INDX_LOG x; x.dword = xf_indx_log;
	xf_indx_log_start(name, xf_indx_log);
	XF_LOG x1;
	x1.length = x.length;
	x1.base = x.base;
	xf_log_main(x1.dword, data);
}

void GP::load_xf() {
	XF_LOG x;
	x.length = GP_QUEUE_GET_WORD + 1;
	x.base = GP_QUEUE_GET_WORD;
	xf_log_start(x.dword);
	if(x.length == 0)
		throw hardware_fatal_exception("GP XP Length is totally whack!");
	if(x.length == 1) {
		handle_xf_single<XFHandlerInterp>(x.base, GP_QUEUE_GET_DWORD);
	} else {
		for(int i=0; i<MIN(x.length, 16); i++) {
			s_xf_data[i] = GP_QUEUE_GET_DWORD;
		}
		handle_xf_multi<XFHandlerInterp>(x.length, x.base, s_xf_data);
	}
	stat.oxf++;
}
void GP::load_xf_indx(char name, BYTE array, BYTE stride) {
	XF_INDX_LOG x;
	x.index = GP_QUEUE_GET_WORD;
	x.word2 = GP_QUEUE_GET_WORD;
	xf_indx_log_start(name, x.dword);
	MYASSERT(sizeof(XF_INDX_LOG) != 4); //temp
	if(m.cp_reg[stride] != x.length * 4u)
		throw hardware_fatal_exception("GP Load Index stride doesn't match length!");
	const DWORD *data = (DWORD*)mem.getp_physical(
		m.cp_reg[array] + m.cp_reg[stride]*x.index, m.cp_reg[stride]);
	if(x.length == 1) {
		handle_xf_single<XFHandlerInterp>(x.base, swapw(*data));
	} else {
		for(size_t i=0; i<x.length; i++) {
			s_xf_data[i] = swapw(data[i]);
		}
		handle_xf_multi<XFHandlerInterp>(x.length, x.base, s_xf_data);
	}
}
void GP::load_xf_indx_a() {
	load_xf_indx('A', 0xAC, 0xBC);
	stat.oxfa++;
}
void GP::load_xf_indx_b() {
	load_xf_indx('B', 0xAD, 0xBD);
	stat.oxfb++;
}
void GP::load_xf_indx_c() {
	load_xf_indx('C', 0xAE, 0xBE);
	stat.oxfc++;
}
void GP::load_xf_indx_d() {
	load_xf_indx('D', 0xAF, 0xBF);
	stat.oxfd++;
}
template void GP::handle_xf_multi<XFHandlerRec>(WORD length, WORD base,
																								const DWORD *data);
template void GP::handle_xf_multi<XFHandlerRecIndx>(WORD length, WORD base,
																										const DWORD *data);
template<class T> void GP::handle_xf_multi(WORD length, WORD base, const DWORD *data) {
	if(base >= XF_TOTAL_SIZE || base + length > XF_TOTAL_SIZE || length > 16)
		throw hardware_fatal_exception("GP XF Illegal Load");
	if(g::gp_log && T::degub) {
		for(int i=0; i<length; i++) {
			xf_dumpword(base, data[i]);
		}
		DEGUB("\n");
	}

	if(base == 0x1018 && length == 2) { //Matrix indices
		T::call(this, &GP::xfr_matrixindex0, data[0]);
		T::call(this, &GP::xfr_matrixindex1, data[1]);
	} else if(base == 0xF0 && length <= 12) { //Identity matrix (?)
		T::call(this, &GP::xfm_identity, data);
	} else if(IS_WVMATRIX_BASE(base) && length == WV_XF_SIZE) {  //WorldView matrix
		//if(!vs_control.set_proj)
		//setWVMatrix(base / WV_XF_SIZE, (float*)data);
		T::call_if(this, !vs_control.set_proj, &GP::setWVMatrix,
			base / WV_XF_SIZE, (float*)data);
	} else if(IS_TMATRIX_BASE(base) && (length == 8 || length == 12)) { //TexCoord matrix
		T::call(this, &GP::setTMatrix, (base - TMAT_XF_BASE) / TMAT_XF_SIZE, (float*)data,
			length == 12);
	} else if(IS_NMATRIX_BASE(base) && length == NORMAL_XF_SIZE) { //Normal matrix
		T::call(this, &GP::setNMatrix, (base - NORMAL_XF_BASE) / NORMAL_XF_SIZE,
			(float*)data);
	} else if(IS_DUALTEX_MATRIX_BASE(base) && length == DUALTEX_XF_SIZE) { //Dualtex matrix
		//} else if(base >= 0x500 && base < 0x600) { //Dualtex matrix
		if(T::degub) {
			GPDEGUB("Dualtex matrix %i ignored\n", (base - DUALTEX_XF_BASE) / DUALTEX_XF_SIZE);
		}
	} else if(IS_LIGHT_BASE(base) && length == LIGHT_XF_SIZE) { //Light
		DWORD index = (base - LIGHT_XF_BASE) / LIGHT_XF_SIZE;
		T::call(this, &GP::xfr_lightcol, index, data[3]);
		T::call(this, &GP::xfm_lightgeo, index, data + 4);
	} else if(base == 0x0604 && length == 6) {  //light 0 attenuation
		T::call(this, &GP::xfm_light0att, data);
	} else if(base == 0x060A && length == 6) {  //light 0 pos&dir    
		T::call(this, &GP::xfm_light0posdir, data);
	} else if(base == 0x1020 && length == 7) {  //Projection matrix
		T::call(this, &GP::xfm_projmatrix, data);
	} else if(base == 0x101A && length == 6) {  //Viewport
		T::call(this, &GP::xfm_viewport, data);
	} else {
		throw hardware_fatal_exception("GP unemulated XF transfer!");
	}

	memcpy(m.xf_mem + base, data, length * 4);
}

template void GP::handle_xf_single<XFHandlerRec>(WORD base, DWORD data);
template<class T> void GP::handle_xf_single(WORD base, DWORD d) {
	if(base >= XF_TOTAL_SIZE)
		throw hardware_fatal_exception("GP XF Illegal Load");
	if(g::gp_log && T::degub) {
		xf_dumpword(base, d);
		DEGUB("\n");
	}

	if(base == 0x0603) {  //Light 0 color
		T::call(this, &GP::xfr_lightcol, 0, d);
	} else if(base == 0x1000) {  //Error
		if(d != 0x3F)
			throw hardware_fatal_exception("GP Unemulated XF Error value!");
	} else if(base == 0x1005) {	//ClipDisable
		T::call(this, &GP::xfr_clipdisable, d);
	} else if(base == 0x1006) {	//Perf0
		T::call(this, &GP::xfr_perf0, d);
	} else if(base == 0x1008) {	//InVtxSpec
		T::call(this, &GP::xfr_invtxspec, d);
	} else if(base == 0x1009) {	//NumChannels
		T::call(this, &GP::xfr_numchannels, d);
	} else if((base & ~1) == 0x100A) {	//Ambient colors
		DWORD index = base - 0x100A;
		T::call(this, &GP::xfr_ambient, index, d);
	} else if((base & ~1) == 0x100C) {	//Material colors
		DWORD index = base - 0x100C;
		T::call(this, &GP::xfr_material, index, d);
	} else if(base >= 0x100E && base <= 0x1011) { //Lighting Channels
		BYTE index = BYTE(base - 0x100E);
		T::call(this, &GP::xfr_channel, index, d);
	} else if(base == 0x1012) {	//DualTexTransformEnable?
		if(d != 1)
			throw hardware_fatal_exception("GP unemulated DualTex setting!");
		//T::call(this, xfr_dualtex_transform_enable, d);
	} else if(base == 0x1018) {	//Matrix indices, geo & tex0-3
		T::call(this, &GP::xfr_matrixindex0, d);
	} else if(base == 0x1019) {	//Matrix indices, tex4-7
		T::call(this, &GP::xfr_matrixindex1, d);
	} else if(base == 0x103F) {	//NumTexGens
		T::call(this, &GP::xfr_numtexgens, d);
	} else if(base >= 0x1040 && base <= 0x1047) { //TexGens
		BYTE index = BYTE(base - 0x1040);
		T::call(this, &GP::xfr_texgen, index, d);
	} else if(base >= 0x1050 && base <= 0x1057) { //Dual TexGens
		BYTE index = BYTE(base - 0x1050);
		T::call(this, &GP::xfr_dualtexgen, index, d);
	} else
		throw hardware_fatal_exception("GP unemulated XF transfer!");
}

void GP::xfr_clipdisable(DWORD d) {
	if(d == 0 || d == 1) {
		GPHR(setRS(D3DRS_CLIPPING, d));
	} else
		throw hardware_fatal_exception("GP Invalid ClipDisable value!");
}

void GP::xfr_perf0(DWORD d) {
	switch(d) {
#define PERF_XF_CASE(name, num) case num: DEGUB("GP XF Perf0 set: %s\n", #name); break;
		PERF_XF(PERF_XF_CASE);
	default:
		DEGUB("GP Unknown XF Perf0: 0x%08X\n", d);
		throw hardware_fatal_exception("GP Unknown XF Perf0!");
	};
}

void GP::xfr_invtxspec(DWORD d) {
	const char *normals[] = { "no ", "standard ", "bi", TROGDOR };
	vs_key.host.ntex = (BYTE)getbitsr(d, 7, 4);
	vs_key.host.nnrm = (BYTE)getbitsr(d, 3, 2);
	vs_key.host.ncol = (BYTE)getbitsr(d, 1, 0);
	GPDEGUB("InVtxSpec: %i colors, %snormals, %i texcoords\n", vs_key.host.ncol,
		normals[vs_key.host.nnrm], vs_key.host.ntex);
	if(vs_key.host.ncol > 2 || vs_key.host.nnrm > 2 || vs_key.host.ntex > 8)
		throw hardware_fatal_exception("GP Illegal InVtxSpec!");
}

void GP::xfr_numchannels(DWORD d) {
	if(d > 2)
		throw hardware_fatal_exception("GP too many color channels!");
	if(vs_key.ncol != d) {
		vs_key.ncol = (BYTE)d;
		vs_control.set = true;
	}
}

void GP::xfr_ambient(DWORD index, DWORD d) {
	D3DCOLORVALUE cv = dword2cv(d);
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_AMBIENT(index), (float*)&cv, 1));
	GPDEGUB("Channel %i Ambient color set\n", index);
}
void GP::xfr_material(DWORD index, DWORD d) {
	D3DCOLORVALUE cv = dword2cv(d);
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_MATERIAL(index), (float*)&cv, 1));
	GPDEGUB("Channel %i Material color set\n", index);
}

void GP::xfr_numtexgens(DWORD d) {
	GPDEGUB("NumTexGens: %i\n", d);
	if(d > 8)
		throw hardware_fatal_exception("GP too many NumTexGens!");
	if(vs_key.ntex != d) {
		vs_key.ntex = (BYTE)d;
		vs_control.set = true;
	}
}

void GP::xfr_texgen(DWORD index, DWORD d) {
	std::string name = STRING_PLUS_DIGIT("TexGen", index);
	BEGIN_FIELDS(d, name.c_str());
	DNAM(emboss_light, 17, 15);
	DNAM(emboss_source, 14, 12);
	DNAMS(source_row, 11, 7, gx::tg_source);
	DNAMS(texgen_type, 6, 4, gx::tg_type);
	DNAS(input_3d, 2);
	DNAS(projection, 1);
	END_FIELDS;
	//if(emboss_light || emboss_source)
	//throw hardware_fatal_exception("GP Unemulated TexGen mode!");

	switch(texgen_type) {
	case gx::TGT_REGULAR:
		if(source_row > gx::TGS_TEX7 || source_row == gx::TGS_COLOR)
			throw hardware_fatal_exception("GP Invalid TexGen input!");
		break;
	case gx::TGT_COLOR_STRGBC0:
	case gx::TGT_COLOR_STRGBC1:
		if(source_row != gx::TGS_COLOR)
			throw hardware_fatal_exception("GP Invalid TexGen input!");
		break;
	case gx::TGT_EMBOSS_MAP:
		break;
	default:
		throw hardware_fatal_exception("GP Unemulated TexGen mode!");
	}
	vs_key.texgen[index].source = source_row;
	vs_key.texgen[index].type = texgen_type;
	vs_key.texgen[index].projection = projection;
	vs_key.texgen[index].input_3d = input_3d;
	//vs_key.texgen[index].dword = d;
	vs_control.set = true;
}

void GP::xfr_dualtexgen(DWORD index, DWORD d) {
	bool normal_enable = getbitr(d, 8);
	DWORD dualmtx = getbitsr(d, 5, 0);
	GPDEGUB("DUALTEX%i: normal_enable %d | dualmtx %d\n", index,
		normal_enable, dualmtx);
	if(normal_enable || dualmtx != 61) {
		throw hardware_fatal_exception("GP unemulated dual texture transform!");
	}
}

void GP::xfm_identity(const DWORD *data) {
	D3DXMATRIX identity;
	if(memcmp(data, D3DXMatrixIdentity(&identity), 12*4) != 0)
		throw hardware_fatal_exception("GP unemulated matrix!");
}

void GP::xfr_lightcol(DWORD index, DWORD d) {
	D3DCOLORVALUE cv = dword2cv(d);
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_LIGHTCOL(index), (float*)&cv, 1));
}

//fix code dupe here
void GP::xfm_lightgeo(DWORD index, const DWORD *data) {
	D3DXVECTOR4 geo[4];
	float *fdata = (float*)data;
	for(int i=0; i<4; i++) {
		geo[i] = D3DXVECTOR4(fdata[i*3+0], fdata[i*3+1], fdata[i*3+2], 1);
	}
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_LIGHTGEO(index), (float*)&geo, 4));
	GPDEGUB("Light %i geo set\n", index);
}
void GP::xfm_light0att(const DWORD *data) {
	D3DXVECTOR4 geo[2];
	float *fdata = (float*)data;
	for(int i=0; i<2; i++) {
		geo[i] = D3DXVECTOR4(fdata[i*3+0], fdata[i*3+1], fdata[i*3+2], 1);
	}
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_LIGHTGEO(0), (float*)&geo, 2));
	GPDEGUB("Light 0 atten set\n");
}
void GP::xfm_light0posdir(const DWORD *data) {
	D3DXVECTOR4 geo[2];
	float *fdata = (float*)data;
	for(int i=0; i<2; i++) {
		geo[i] = D3DXVECTOR4(fdata[i*3+0], fdata[i*3+1], fdata[i*3+2], 1);
	}
	GPHR(m.pd3dDevice->SetVertexShaderConstantF(VSC_LIGHTGEO(0)+2, (float*)&geo, 2));
	GPDEGUB("Light 0 pos&dir set\n");
}

void GP::xfm_projmatrix(const DWORD *data) {
	D3DXMATRIX matrix;
	D3DXMatrixIdentity(&matrix);
#define SIX(macro) macro(0) macro(1) macro(2) macro(3) macro(4) macro(5)
#define DECLARE_PROJ_FLOAT(num) float p##num = MAKE(float, data[num]);
	SIX(DECLARE_PROJ_FLOAT);

	GPDEGUB("Setting projection matrix using %.6g %.6g %.6g %.6g %.6g %.6g\n",
		p0, p1, p2, p3, p4, p5);
	float l, r, t, b, n, f; //RECT, near, far

	//This is ortho (0x1026 == 1). persp(== 0) uses different positions in the matrix.
	matrix._11 = p0;
	matrix._22 = p2;
	matrix._33 = p4;
	matrix._43 = p5;

	if(data[6]) {	//orthogonal
		matrix._41 = p1;
		matrix._42 = p3;
		matrix._44 = 1;
		//hack
		//matrix._33 *= -1;
		//matrix._43 *= -1;
		matrix._43 += 1;

		l = -(1.0f + p1) / p0;
		r = (1.0f - p1) / p0;
		t = (1.0f + p3) / p2;
		b = -(1.0f - p3) / p2;
		n = (p5 + 1.0f) / p4;
		f = p5 / p4;
		GPDEGUB("Orthogonal\n");
	} else {  //perspective, right-hand?
		matrix._31 = p1;
		matrix._32 = p3;
		matrix._44 = 0;
		matrix._34 = -1;

		n = (p5*(1.0f + p4) - p5*p4) / p4;  //ERROR?
		f = (p4*n) / (1.0f + p4);
		b = (p2*(p3 - 1.0f)) / (4*n);
		t = (p2 + 2*n*b) / (2*n);
		l = (2*n) / (p0*(((p1 + 1.0f) / (p1 - 1.0f)) - 1.0f));
		r = l*((p1 + 1.0f) / (p1 - 1.0f));

		GPDEGUB("Perspective, right-hand (?).\n");
		if(g::gp_log && g::verbose) {
			DEGUB("Original matrix:\n");
			//D3DXMATRIX scale;
			//D3DXMatrixMultiply(&matrix, &matrix, D3DXMatrixScaling(&scale, -1, -1, -1));
			D3DXMATRIX temp;
			dump_matrix(&matrix);
			DEGUB("Compare using calculated values:\n");
			dump_matrix(D3DXMatrixPerspectiveOffCenterRH(&temp, l, r, b, t, n, f));
			DEGUB("Static Compare:\n");
			float     left    = -0.050F;
			float     top     = 0.0375F;
			float     znear   = 0.1F;
			float     zfar    = 10.0F;
			dump_matrix(D3DXMatrixPerspectiveOffCenterRH(&temp,
				left, -left, -top, top, znear, zfar));
		}

		matrix._33 -= 1;
	}
	GPDEGUB("Calculated source values tlbrnf: %g %g %g %g %g %g\n",
		t, l, b, r, n, f);

	//wyrd
	//D3DXMATRIX scale, m2;
	//D3DXMatrixMultiply(&m2, &matrix, D3DXMatrixScaling(&scale, 1, 1, -1/ZMAX));
	//D3DXMatrixMultiply(&m2, &matrix, D3DXMatrixScaling(&scale, 1, 1, -((f-n)*1000)/ZMAX));
	//matrix = m2;

	if(g::gp_log && g::verbose) {
		dump_matrix(&matrix);
	}
	vs_control.matProj = matrix;
	vs_control.set_proj = true;
	//if(data[6]) {
	//GPHR(m.pd3dDevice->SetTransform(D3DTS_PROJECTION, &matrix));
	//} else {
	//GPHR(m.pd3dDevice->SetTransform(D3DTS_PROJECTION, &compare_matrix));
	//}
}

void GP::xfm_viewport(const DWORD *data) {
	float A = MAKE(float, data[0]);
	float B = MAKE(float, data[1]);
	float C = MAKE(float, data[2]);
	float D = MAKE(float, data[3]);
	float E = MAKE(float, data[4]);
	float F = MAKE(float, data[5]);
	/*D3DVIEWPORT9 viewport;
	viewport.Width = DWORD(2*A);
	viewport.Height = DWORD(-2*B);
	viewport.X = DWORD(D - A - 342);
	viewport.Y = DWORD(E + B - 342);
	viewport.MaxZ = F / ZMAX;
	viewport.MinZ = (F - C) / ZMAX;*/
	float w = 2*A;
	float h = -2*B;
	float x = D - A - 342;
	float y = E + B - 342;
	float f = F / ZMAX;
	float n = (F - C) / ZMAX;
	//int real_height = (h > 479) ? 480 : 448;
	//h *= (480.0f / 448);
	//x *= (480.0f / 448);
	//y *= 480.0f / real_height;

	//hacky
	/*float hn = (3*w)/4;
	float yn = (y*hn)/h;
	GPDEGUB("Old hy: %.6g %.6g\n", h, y);
	h = hn;
	y = yn;*/
	if(y < 0)
		y = 0;
	if(x < 0)
		x = 0;
	if(x + w > WIDTH)
		w -= (x + w) - WIDTH;
	if(y + h > HEIGHT)
		h -= (y + h) - HEIGHT;

	//copied from Dolphin
	/*float x=(D-662)*2;
	float y=(D-582)*2; //something is wrong, but what??
	y-=16;
	float w=A*2;  //multiply up to real size 
	float hw=B*-2; //why is this negative? oh well..
	if(x<0.0f) x=0.0f;
	if(y<0.0f) y=0.0f;
	if(x>WIDTH) x=WIDTH - 1;
	if(y>HEIGHT) y=HEIGHT - 1;
	/*if(w<0) w=1;
	if(hw<0) hw=1;*/
	/*if(w<0) throw hardware_fatal_exception("GP bad viewport");
	if(hw<0) throw hardware_fatal_exception("GP bad viewport");
	if(x+w > WIDTH) w=WIDTH-x;
	if(y+hw > HEIGHT) hw=HEIGHT-y;*/
	//end of copy

	VGPDEGUB("Viewport in: %.6g %.6g %.6g %.6g %.6g %.6g\n",
		A, B, C, D, E, F);
	VGPDEGUB("Out: %.6g %.6g, %.6g %.6g, %.6g %.6g\n",
		w, h, x, y, n, f);
	D3DVIEWPORT9 viewport = { (DWORD)x, (DWORD)y, (DWORD)w, (DWORD)h, n,
		CLAMPHIGH(f, 1) };
	VGPDEGUB("Resulting D3DVIEWPORT9: %i %i, %i %i, %.6g(0x%08X) %.6g(0x%08X)\n",
		viewport.X, viewport.Y, viewport.Width, viewport.Height,
		viewport.MinZ, MAKE(DWORD, n), viewport.MaxZ, MAKE(DWORD, f));
	if(viewport.Width > 1 && viewport.Height > 1) {
		GPHR(m.pd3dDevice->SetViewport(&viewport));
		GPDEGUB("Viewport set.\n");
	}
}

void GP::xfr_channel(DWORD index, DWORD d) {
	const char *source[] = { "register", "vertex" };
	const char *diff[] = { "none", "sign", "clamp", TROGDOR };
	const char *att[] = { "specular", "spotlight" };
#define LIGHT_BITS(macro) macro(0, 2) macro(1, 3) macro(2, 4) macro(3, 5)\
	macro(4, 11) macro(5, 12) macro(6, 13) macro(7, 14)

	MYASSERT(index < 4);
	WORD base = 0x100E + (WORD)index;
	if(d != m.xf_mem[base]) {
		const bool alpha = index >= 2;
		index &= 1;
		VS_KEY::CHANNEL &channel = (alpha ? vs_key.alpha : vs_key.color)[index];
		channel.word = (WORD)d;

#define DEGUB_ONE_LIGHT(num, bit) ,(getbitr(d, bit) ? " #"#num : "")
		GPDEGUB("%s%i lighting changed: %s. Material source: %s. Ambient source: %s. "
			"Diffuse function: %s. Attenuation: %s. Attenuation function: %s. "
			"Lights enabled:%s%s%s%s%s%s%s%s\n", (alpha ? "Alpha" : "Color"), index,
			abled(channel.lit), source[channel.material_source_vertex],
			source[channel.ambient_source_vertex], diff[channel.diffuse_func],
			abled(channel.atten_enabled), att[channel.atten_func] LIGHT_BITS(DEGUB_ONE_LIGHT));

		if(channel.diffuse_func == 3)
			throw hardware_fatal_exception("GP Invalid Light Diffuse Function!");
	}
}

void GP::xfr_matrixindex0(DWORD d) {
	BYTE index = (BYTE)getbitsr(d, 5, 0);
	GPDEGUB("Matrix indices: geo %i", index);
	if(index % 3 != 0 || index > 27)
		throw hardware_fatal_exception("GP unemulated matrix index");
	index /= 3;
	if(index != vs_key.matrix_index[MI_GEO]) {
		vs_key.matrix_index[MI_GEO] = index;
		vs_control.set = true;
	}
	for(int i=0; i<4; i++) {
		index = (BYTE)getbitsr(d, (i+2)*6-1, (i+1)*6);
		do_texmatindex(i, index);
	}
	GPDEGUB("\n");
	if(d != m.cp_reg[0x30]) {
		throw hardware_fatal_exception("GP Matrix index discrepancy!");
	}
}
void GP::xfr_matrixindex1(DWORD d) {
	GPDEGUB("Matrix indices: ");
	for(int i=0; i<4; i++) {	
		BYTE index = (BYTE)getbitsr(d, i*6+5, i*6);
		do_texmatindex(i+4, index);
	}
	GPDEGUB("\n");
	if(d != m.cp_reg[0x40]) {
		throw hardware_fatal_exception("GP Matrix index discrepancy!");
	}
}
void GP::do_texmatindex(int i, BYTE index) {
	GPDEGUB(" tex%i %i", i, index);
	if(index % 3 != 0 || index > 60)
		throw hardware_fatal_exception("GP unemulated matrix index");
	index = (index - 30) / 3;
	if(vs_key.matrix_index[MI_TEX(i)] != index) {
		vs_key.matrix_index[MI_TEX(i)] = index;
		vs_control.set = true;
	}
	/*bool use_tmatrix = index != 60 && index >= 30;
	if(vs_key.texgen[i].use_tmatrix != use_tmatrix) {
	vs_key.texgen[i].use_tmatrix = use_tmatrix;
	vs.set = true;
	}*/
}
